//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
/*+==========================================================================
  Plik:      sockget.cs

  Opis:      Przedstawia zastosowanie gniazd asynchronicznych przy uyciu klasy 
             Socket w URT Frameworks SDK. Program wysya "GET" do okrelonego 
             serwera WWW, a nastpnie odczytuje domyln stron internetow.

  Klasy:     AsyncData, SockGet

  Funkcje:   Main, DoGet, DoSend, DoReceive, ConnectCallback, SendCallback,
             ReceiveCallback

----------------------------------------------------------------------------  

  Copyright (C) 2000 Microsoft Corporation.  Wszystkie prawa zastrzeone.
==========================================================================+*/

using System;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading;

public class AsyncData
{
	public Socket socket;
	public byte[] RecBytes = new byte[256];
}

public class SockGet
{

	private static string server = "localhost";
	private static string path = "";
	private static string Page = "";
	private static AsyncData ad = new AsyncData();
	private static int BytesReceived = -1; // Nie moe mie wartoci 0

	private static ManualResetEvent ConnectDone = new ManualResetEvent(false);
	private static ManualResetEvent SendDone = new ManualResetEvent(false);
	private static ManualResetEvent ReceiveDone = new ManualResetEvent(false);
	
	public static void Main (string [] args) 
	{        
		if (args.Length < 1)
		{
			Console.WriteLine("Nie wprowadzono nazwy serwera. Domylnie jest to localhost.");
		}
		else
			server = args[0];
				        
		DoGet();        
	}

	public static Socket GetSocket(string host, int port) 
	{
		Socket s = null;
		IPHostEntry iphe = Dns.Resolve(host);
		// Ptla dla wszystkich adresw, 
		// a nie tylko pierwszego. 
		foreach(IPAddress ipa in iphe.AddressList) 
		{
			IPEndPoint ipe = new IPEndPoint(ipa, port);
		
			// Naley uy AddressFamily bdcej czci
			// punktu kocowego. 
			// AddressFamily.InterNetwork ogranicza tylko
			// do IPv4
			Socket ts = new Socket(ipe.AddressFamily,
				SocketType.Stream,
				ProtocolType.Tcp);
			try 
			{
				// Zwrcenie pierwszego gniazda, z ktrym
				// mona nawiza poczenie.
				ts.Connect(ipe);
				s = ts;
				break;
			} 
			catch (ArgumentNullException ae)
			{
				Console.WriteLine("Wyjtek ArgumentNullException: " + ae.ToString());
			}
			catch (SocketException se)
			{				
				Console.WriteLine("Wyjtek SocketException: " + se.ToString());
			}
			catch (Exception e) 
			{
				Console.WriteLine("Poczenie nie powiodo si: " + e.ToString());
			}
		}
		return s;
	}

	private static void DoGet()
	{
		try
		{
            Socket s = GetSocket(server, 80);

			s.Blocking = false; // domylna warto to true

			// Ustawia czas oczekiwania wysyki i odbioru na 10 sekund.
			s.SetSocketOption(SocketOptionLevel.Socket, 
				SocketOptionName.SendTimeout,
				10000);

			s.SetSocketOption(SocketOptionLevel.Socket, 
				SocketOptionName.ReceiveTimeout,
				10000);

			DoSend(s);
			SendDone.WaitOne();
			                			
			DoReceive(s);		
            
			Console.WriteLine("\nDomylna strona HTML na " + server + " zostaa odebrana\n");
			Console.WriteLine(Page);			

			s.Shutdown(SocketShutdown.Both);
			s.Close();
		}

		catch (Exception e)
		{
			Console.WriteLine("Wyjtek Exception: " + e.Message);
			Console.WriteLine("Wyjtek StackTrace: " + e.StackTrace);
			return;
		}
	}

	private static void DoSend(Socket s) 
	{				
		Encoding ASCII = Encoding.ASCII;
		string Get = "GET /" + path + " HTTP/1.1\r\nHost: " + server + "\r\nConnection: Close\r\n\r\n";
		Byte[] ByteGet = ASCII.GetBytes(Get);            

		IAsyncResult result = s.BeginSend(ByteGet,                
			0,
			ByteGet.Length, 
			0,
			new AsyncCallback(SendCallback),
			s);        			
        
		return;		
	}

	private static void SendCallback(IAsyncResult result) 
	{        
		try
		{

			Socket socket = (Socket) result.AsyncState;

			int sentBytes = socket.EndSend(result);
			Console.WriteLine("\Wysano " + sentBytes + " bajtw do " + server);
        
			SendDone.Set();
			return;
		}

		catch (SocketException e)
		{
			// Wysyanie danych nie powiodo si.

			Console.WriteLine("Nie mona wysa danych do: " + server);
			Console.WriteLine("\nWyjtek SocketException: " + e.Message);
			Console.WriteLine("Kod bdu: " + e.NativeErrorCode);
			Console.WriteLine("StackTrace: " + e.StackTrace);	

			return;		
		}
	}

	private static void DoReceive(Socket s)
	{				
		try
		{
			ad.socket = s;

			while (BytesReceived != 0)
			{
				ReceiveDone.Reset();


				IAsyncResult result = s.BeginReceive(ad.RecBytes,
					0,
					ad.RecBytes.Length,
					SocketFlags.None,
					new AsyncCallback(ReceiveCallback),
					null); 

				ReceiveDone.WaitOne();        
			}		
                
			ReceiveDone.Set();
			return;
		}

		catch (SocketException e)
		{
			// Odbir danych nie powid si.

			Console.WriteLine("Bd w czasie odbioru danych z: " + server);
			Console.WriteLine("\nWyjtek SocketException: " + e.Message);
			Console.WriteLine("Kod bdu: " + e.NativeErrorCode);
			Console.WriteLine("StackTrace: " + e.StackTrace);	

			return;
		}
	}

	private static void ReceiveCallback(IAsyncResult result) 
	{
		try
		{    
			Encoding ASCII = Encoding.ASCII;
			BytesReceived = ad.socket.EndReceive(result);							

			Page += ASCII.GetString(ad.RecBytes, 0, BytesReceived);
						
			ReceiveDone.Set();
			return;
		}

		catch (SocketException e)
		{
			// Odbir danych nie powid si.

			Console.WriteLine("Bd w czasie odbioru danych z: " + server);
			Console.WriteLine("\Wyjtek nSocketException: " + e.Message);
			Console.WriteLine("Kod bdu: " + e.NativeErrorCode);
			Console.WriteLine("StackTrace: " + e.StackTrace);	

			return;		
		}
	}

} // SockGet
